--isso é o token
--token é como uma "fatia" de código/texto, o dado bruto, que está sendo processada pelo lexer

--token possui o "kind" que é um tipo/nome/identificação que está representado aquela fatia/código/texto/dado bruto
--token possui o "value" que é a fatia/código/texto/dado bruto em si, mas nem sempre é necessario, apenas "kind" é o suficiente
--token não entende nada, só diz oque a fatia parece ser
--para ele é "isso parece um número" ou "isso parece um texto" ou "isso parece o símbolo + "

--exemplos de representações
--{Number, 123} isso é o token que representa o número
--{Boolean, true} isso é o token que representa o booleano verdadeiro
--{Sum} isso é o token que representa o símbolo "+", nesse token não é necessario o "value", então só usar o "kind" é o suficiente

--quem cria esses tokens é o lexer, ele decide oque cada coisa é, como será identificado

--os tipos/nomes/identificações possiveis de tokens
---@alias TokenKind 
---| "Nil"
---| "Boolean"
---| "Number"
---| "String"
---
---| "If"
---| "Else"
---| "Declare"
---| "Function"
---| "Defer"
---| "For"
---| "While"
---| "Or"
---| "And"
---| "Not"
---
---| "Identifier"
---
---| "Sum"
---| "Minus"
---| "Asterisk"
---| "Slash"
---
---| "Assign"
---| "Equal"
---| "Greater"
---| "GreaterEqual"
---| "Less"
---| "LessEqual"
---
---| "OpenParen"
---| "CloseParen"
---| "OpenKey"
---| "CloseKey"
---| "OpenBracket"
---| "CloseBracket"
---
---| "Dot"
---| "Colon"
---| "Comma"

---@class Token
---@field __type "Token"
---@field kind TokenKind
---@field value nil|string
local Token = {}
Token.__index = Token
Token.__type = "Token"
---cria um novo token
---@param kind TokenKind --tipo do token
---@param value ?string --o valor do token, dado bruto
---@return Token
function Token.new(kind, value)
    return setmetatable({
        kind = kind,
        value = value
    }, Token)
end
return Token